/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;

public class MachineId
implements Serializable {
    static final long serialVersionUID = 5505875758577820946L;
    private static final String TRACE_MASKD = "XFCSMIDD";
    private static final String TRACE_MASKF = "XFCSMIDF";
    private static final String TRACE_MASKT = "XFCSMIDT";
    private String name;
    private String group;
    private double version;
    private int type;
    private int fcsVersion;
    private InetAddress[] nicAddresses;
    private boolean[] publicNetworkIndicators;
    private String machineType;
    private String machineModel;
    private String machineSerial;

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses) {
        if (name == null) {
            throw new IllegalArgumentException("Name passed to MachineId can not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group passed to MachineId can not be null");
        }
        if (nicAddresses == null) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId can not be null");
        }
        if (nicAddresses.length < 1) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId must have at least one member");
        }
        this.name = name;
        this.group = group;
        this.version = version;
        this.type = type;
        this.fcsVersion = fcsVersion;
        this.nicAddresses = nicAddresses;
        this.publicNetworkIndicators = new boolean[nicAddresses.length];
    }

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses, boolean[] publicNetworkIndicators) {
        if (name == null) {
            throw new IllegalArgumentException("Name passed to MachineId can not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Group passed to MachineId can not be null");
        }
        if (nicAddresses == null) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId can not be null");
        }
        if (nicAddresses.length < 1) {
            throw new IllegalArgumentException("NICAddresses passed to MachineId must have at least one member");
        }
        if (publicNetworkIndicators == null) {
            throw new IllegalArgumentException("publicNetworkIndicators passed to MachineId can not be null");
        }
        if (publicNetworkIndicators.length != nicAddresses.length) {
            throw new IllegalArgumentException("publicNetworkIndicators passed to MachineId must have the same number of members as NICAddresses");
        }
        this.name = name;
        this.group = group;
        this.version = version;
        this.type = type;
        this.fcsVersion = fcsVersion;
        this.nicAddresses = nicAddresses;
        this.publicNetworkIndicators = publicNetworkIndicators;
    }

    public MachineId(String name, String group, double version, int type, int fcsVersion, InetAddress[] nicAddresses, boolean[] publicNetworkIndicators, String machineType, String machineModel, String machineSerial) {
        this(name, group, version, type, fcsVersion, nicAddresses, publicNetworkIndicators);
        this.machineType = machineType;
        this.machineModel = machineModel;
        this.machineSerial = machineSerial;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public double getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public int getFcsVersion() {
        return this.fcsVersion;
    }

    public InetAddress[] getNicAddresses() {
        return this.nicAddresses;
    }

    public boolean[] getPublicNetworkIndicators() {
        return this.publicNetworkIndicators;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getMachineModel() {
        return this.machineModel;
    }

    public String getMachineSerial() {
        return this.machineSerial;
    }

    public String getMTMS() {
        if (this.machineType != null && this.machineModel != null && this.machineSerial != null) {
            return this.machineType + "_" + this.machineModel + "-" + this.machineSerial;
        }
        return "";
    }

    public String toString() {
        int i;
        String returnString = "[MachineId: \nName: " + this.name + ", Group: " + this.group;
        if (!this.getMTMS().equals("")) {
            returnString = returnString + ", MTMS: " + this.getMTMS();
        }
        if (this.nicAddresses != null) {
            i = 0;
            while (i < this.nicAddresses.length) {
                returnString = this.nicAddresses[i] != null ? returnString + ", NIC Address[" + i + "]:" + this.nicAddresses[i].getHostName() : returnString + ", NIC Address[" + i + "]: null";
                ++i;
            }
        }
        if (this.publicNetworkIndicators != null) {
            i = 0;
            while (i < this.publicNetworkIndicators.length) {
                returnString = returnString + ", Public Network[" + i + "]:" + this.publicNetworkIndicators[i];
                ++i;
            }
        }
        return returnString;
    }

    public int hashCode() {
        int i;
        int tempHash = 0;
        if (this.nicAddresses != null) {
            i = 0;
            while (i < this.nicAddresses.length) {
                if (this.nicAddresses[i] != null) {
                    tempHash += this.nicAddresses[i].hashCode();
                }
                ++i;
            }
        }
        if (this.publicNetworkIndicators != null) {
            i = 0;
            while (i < this.publicNetworkIndicators.length) {
                tempHash += this.publicNetworkIndicators[i] ? 1 : 2;
                ++i;
            }
        }
        if (this.machineType != null) {
            tempHash += this.machineType.hashCode();
        }
        if (this.machineModel != null) {
            tempHash += this.machineModel.hashCode();
        }
        if (this.machineSerial != null) {
            tempHash += this.machineSerial.hashCode();
        }
        return this.name.hashCode() + this.group.hashCode() + new Double(this.version).hashCode() + new Integer(this.type).hashCode() + new Integer(this.fcsVersion).hashCode() + tempHash;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof MachineId) {
            return this.name.equals(((MachineId)o).getName()) && this.group.equals(((MachineId)o).getGroup()) && this.type == ((MachineId)o).getType() && this.fcsVersion == ((MachineId)o).getFcsVersion() && Arrays.equals(this.nicAddresses, ((MachineId)o).getNicAddresses()) && Arrays.equals(this.publicNetworkIndicators, ((MachineId)o).getPublicNetworkIndicators());
        }
        return false;
    }
}

